<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
	<xsl:output method="xml" encoding="utf-8" indent="yes" />

	<!-- 
	
	Author: Ryo Sode 
	Last Modified: 06/09/02
	
	Description: RSS to FMPXMLRESULT transformer for getting RSS Headline. This will enable FileMaker Pro database to be used as temp storage for storing headline information from the top headline on the website.

	Technical Background:

	This transformation is created based on Rich Site Summary (RSS) 0.91 DTD. We extract the information contained in <item> elements where all the good stuff reside.

	A lot of RSS 0.91 compliant XML live-feeds are fed through websites such as moreover.com. figby.com has a number of links to various RSS as well.
	
	Quote:
	"RSS is an XML vocabulary for describing metadata abut websites, and enabling the display of "channels" on the "My Netscape" website." (From 0.91 RSS DTD)
	
	-->
	
	<xsl:template match="/rss/channel">
<FMPXMLRESULT xmlns="http://www.filemaker.com/fmpxmlresult">
	<ERRORCODE>0</ERRORCODE>
	<PRODUCT BUILD="" NAME="FileMaker Pro XML Import" VERSION="6.0v1" />
	<DATABASE DATEFORMAT="yyyy.MM.dd" LAYOUT="" NAME="" RECORDS="" TIMEFORMAT="k:mm:ss" />
	<METADATA>
		<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="feed title" TYPE="TEXT" />
		<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="title" TYPE="TEXT" />
		<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="link" TYPE="TEXT" />
		<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="description" TYPE="TEXT" />
	</METADATA>
	<RESULTSET FOUND="15">
		<xsl:for-each select="item" >
			<xsl:variable name="c">
				<xsl:value-of select="position()" />
			</xsl:variable>
		<ROW MODID="$c" RECORDID="$c" >
			<COL><DATA><xsl:value-of select="//title" /></DATA></COL>
			<COL><DATA><xsl:value-of select="title" /></DATA></COL>
			<COL><DATA><xsl:value-of select="link" /></DATA></COL>
			<COL><DATA><xsl:value-of select="description" /></DATA></COL>
		</ROW>
		</xsl:for-each>
	</RESULTSET>
</FMPXMLRESULT>
	</xsl:template>
</xsl:stylesheet>